#include <iostream>
#include <vector>
#include <algorithm>
#include <cmath>
#include <iomanip>
#include <map>
#include <set>
#include <cstdio>
#include <random>
#include <string>

using namespace std; //higz :)
using vii = vector<int>;
using ll = long long;
using vll = vector<ll>;
using vvi = vector<vii>;
using vvll = vector<vll>;
using vbb = vector<bool>;
using vvbb = vector<vbb>;
using pii = pair<int, int>;
using vpii = vector<pii>;
using ld = long double;
using pll = pair<ll, ll>;

struct Segment{
    ll xs = 0, ys = 0, xe = 0, ye = 0;
};

struct Point{
    ll x, y;
    Point(int x0 = 0, int y0 = 0) {
        x = x0;
        y = y0;
    }
};

struct Vector{
    ll x, y;
    Vector(Point A, Point B) {
        x = B.x - A.x;
        y = B.y - A.y;
    }
};

int MySign(ll a) {
    if (a == 0) {
        return 0;
    }
    if (a > 0) {
        return 1;
    } else {
        return -1;
    }
}

ll operator %(Vector a, Vector b) {
    return a.x * b.y - a.y * b.x;
}

bool check(Segment aa, Segment bb) {
    Point A1(aa.xs, aa.ys), B1(aa.xe, aa.ye);
    Point A2(bb.xs, bb.ys), B2(bb.xe, bb.ye);
    Vector a1a2(A1, A2), a1b2(A1, B2);
    Vector a2b1(A2, B1), a2a1(A2, A1);
    Vector ab1(A1, B1), ab2(A2, B2);
    bool flag = 1;
    if (MySign(ab1 % a1a2) != MySign(ab1 % a1b2)) {
        flag = 1;
    } else {
        return 0;
    }
    if (MySign(ab2 % a2a1) != MySign(ab2 % a2b1)) {
        flag = 1;
    } else {
        return 0;
    }
    return flag;
}

const int MOD = 998244353;

ll binpow(ll val, int q) {
    if (!q) {
        return 1;
    }
    if (q % 2) {
        return (val * binpow(val, q - 1)) % MOD;
    }
    return binpow((val * val) % MOD, q / 2);
}

void solve() //#bring cf back
{
    ll m, n, w, h, x, y;
    cin >> m >> n >> w >> h >> x >> y;
    ll res = 0;
    res += (x + w - 1) / w;
    res += (m - x - w + w - 1) / w;
    res++;
    ll ans = 0;
    ans += res * ((y + h - 1) / h);
    ans += res;
    ans += res * ((n - y - h + h - 1) / h);
    ans--;
    cout << ans << '\n';
}

int main()
{
#ifdef _DEBUG
    freopen("in.txt", "r", stdin);
    //freopen("out.txt", "w", stdout);
#else
    ios_base::sync_with_stdio(false);
    cin.tie(0);
    cout.tie(0);
#endif // _DEBUG
    int t;
#ifdef SOLOTEST
    t = 1;
#else
    cin >> t;
#endif
    while (t--) {
        solve();
    }
}
